/**
 * \file: svg_font_harfbuzz.c
 *
 * \version: $Id: svg_font_harfbuzz.h,v 0.1 2014/09/04 11:02:54 $
 *
 * \component:  svg_font_harfbuzz for shaping with harfbuzz library 
 *
 * \author:Karthiraman,Anil
 *
 * \copyright: (c) 2003 - 2004 ADIT Corporation
 *
 * \history
 *
 ***********************************************************************/
#ifndef GRL_HB_FONT_H
#define GRL_HB_FONT_H


#include "svg_typedef.h"
#include "svg_error.h"
#include "svg_font_err.h"
#include "grlft_font.h"
#include "svg_font.h"

#include "hb-ft.h"

#define UNUSED_VAR(arg) arg=arg;
#define MAX_SIZE_HB_CHARINDEXLIST 	4096 /* 1 page size */

/**
 *  @struct Structure definition for shaping- harfbuzz engine  
 */
typedef struct
{
    hb_font_t*					hb_fonthndl;
   	hb_glyph_info_t* 			glyph_infos;
	hb_glyph_position_t*	   	glyph_positions;
    hb_buffer_t*	 			buffer;
    SVGUint32					glyph_count;
    hb_direction_t				rendr_direction;
    hb_script_t					langscript;
    hb_user_data_key_t	        userdatakey;
    void*						p_charIndexList;
    SVGUint32					charindexlistsize;
}HB_INFO_STRUCT;


/**
 * @fn grlhbcreatefont
 *
 * <brief description>.
 * <detailed description>
 *
 * @param  void       : Pointer to shape eng struct
 * @param  FT_Face    : Pointer to font face
 *
 * @return SVG error
 */
 SVGError grlhbCreateFont( void *p_shapeeng,FT_Face face );

/**
 * @fn grlhbDeleteFont
 *
 * <brief description>.
 * <detailed description>
 *
 * @param  void       : Pointer to shape eng struct
 *
 * @return SVGUint32 : SVG error
 */
 SVGError grlhbDeleteFont( void *p_shapeeng );

/**
 * @fn grlhbGlyphShaping
 *
 * <brief description>.
 * <detailed description>
 *
 * @param  void       : Pointer to shape eng struct
 * @param  SVGUint8	  : pointer to char info struct
 * @param  void       : Pointer to svgfontcontext 
 *
 * @return SVG error
 */	
 SVGError grlhbGlyphShaping( void *p_shapeeng,
      						get_char_info_struct* pchar_info,
      						void *cachedctx,
      						SVGUint32 encoding);

/**
 * @fn grlhbGetGlyphCount
 *
 * <brief description>.
 * <detailed description>
 *
 * @param  void       : Pointer to shape eng struct
 *
 * @return SVGUint32  : Glyph count
 */
 SVGUint32 grlhbGetGlyphCount( void *p_shapeeng );


 /**
 * @fn grlhbGetGlyphOffsets
 *
 * <brief description>.
 * <detailed description>
 *
 * @param  void 	  			: Pointer to shape eng struct
 * @param  SVGUint32       		: glyphindex
 * @param  SVGInt32       		: Xoffset
 * @param  SVGInt32       		: Yoffset
 *
 * @return void
 */
 void grlhbGetGlyphOffsets( void *p_shapeeng,
 								SVGUint32 glyphindex,
 								SVGInt32 *Xoffset,
 								SVGInt32 *Yoffset );


/**
 * @fn grlhbSetLangscript
 *
 * <brief description>.
 * <detailed description>
 *
 * @param  void 	  			: Pointer to shape eng struct
 * @param  In_langscript		: language script
 * @param  In_Rendrdirection    : Rendr direction
 *
 * @return SVGUint32 : previous language script
 */
 SVGUint32 grlhbSetLangscript_rendrdirection( void *p_shapeeng,
                                                                    SVGUint32 In_langscript,
                                                                    SVGUint32 In_Rendrdirection);
 /**
  * @fn grlhbGetGlyphCharIndex
  *
  * <brief description>.
  * <detailed description>
  *
  * @param  void       : Pointer to shape eng struct
  * @param  SVGUint32  : glyphindex
  *
  * @return SVGUint32 : Glyph char index
  */
  SVGUint32 grlhbGetGlyphCharIndex( void *p_shapeeng,SVGUint32 glyphindex );

 /**
  * @fn grlhbDestroyBuffer
  *
  * <brief description>.
  * <detailed description>
  *
  * @param  void       : Pointer to shape eng struct
  *
  */
  void grlhbDestroyBuffer( void *p_shapeeng );

 /**
  * @fn hb_svg_glyph_metrics
  *
  * <brief description>.
  * <detailed description>
  *
  * @param	hb_font_t		 	 : Pointer to Font context of harfbuzz
  * @param	hb_codepoint_t		 : Glyph char index
  * @param	void				 : Pointer to cachedctx
  *
  * @return	hb_glyph_metrics_t	 : update glyphmetrics
  * @return SVGUint32 			 : SVG error
  */
hb_bool_t hb_svg_glyph_metrics(hb_font_t *font,
							   hb_codepoint_t glyph,
							   void 	*cachedctx,							   
							   hb_glyph_metrics_t *glyphmetrics);

#endif /* GRL_HB_FONT_H */

